% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.robin.R
\name{predict.roben}
\alias{predict.roben}
\title{make predictions from a roben object}
\usage{
\method{predict}{roben}(object, X.new, E.new, clin.new = NULL, Y.new = NULL, ...)
}
\arguments{
\item{object}{roben object.}

\item{X.new}{a matrix of new values for X at which predictions are to be made.}

\item{E.new}{a vector of new values for E at which predictions are to be made.}

\item{clin.new}{a vector or matrix of new values for clin at which predictions are to be made.}

\item{Y.new}{a vector of the response of new observations. If provided, the prediction error will be computed based on Y.new.}

\item{...}{other predict arguments}
}
\value{
an object of class `roben.pred' is returned, which is a list with components:
\item{error}{prediction error. error is NULL is Y.new=NULL.}
\item{y.pred}{predicted values of the new observations.}
}
\description{
make predictions from a roben object
}
\details{
X.new (E.new) must have the same number of columns as X (E) used for fitting the model. If clin was provided when fit the model, clin.new
must not be NULL, and vice versa. The predictions are made based on the posterior estimates of coefficients in the roben object.
Note that the main effects of environmental exposures E are not subject to selection.

If Y.new is provided, the prediction error will be computed. For robust methods, the prediction mean absolute deviations (PMAD) will be computed.
For non-robust methods, the prediction mean squared error (PMSE) will be computed.
}
\examples{
data(GxE_small)
test=sample((1:nrow(X)), floor(nrow(X)/5))
fit=roben(X[-test,], Y[-test,], E[-test,], clin[-test,], iterations=5000)
predict(fit, X[test,], E[test,], clin[test,], Y[test,])

}
\seealso{
\code{\link{roben}}
}
