% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_mediation}
\alias{plot_mediation}
\alias{plot_mediation.boot_test_mediation}
\alias{plot_mediation.sobel_test_mediation}
\alias{plot_mediation.list}
\alias{plot_mediation.default}
\alias{autoplot.test_mediation}
\alias{plot.test_mediation}
\title{Plot (robust) mediation analysis results}
\usage{
plot_mediation(object, ...)

\method{plot_mediation}{boot_test_mediation}(object, method = c("dot",
  "density"), parm = NULL, ...)

\method{plot_mediation}{sobel_test_mediation}(object, data,
  method = c("dot", "density"), parm = c("c", "ab"), level = 0.95,
  ...)

\method{plot_mediation}{list}(object, data, method = c("dot", "density"),
  parm = NULL, level = 0.95, ...)

\method{plot_mediation}{default}(object, mapping = attr(object,
  "mapping"), facets = attr(object, "facets"), ...)

\method{autoplot}{test_mediation}(object, ...)

\method{plot}{test_mediation}(x, ...)
}
\arguments{
\item{object, x}{an object inheriting from class
\code{"\link{test_mediation}"} containing results from (robust) mediation
analysis.  For \code{plot_mediation}, a list of such objects may be supplied
as well.}

\item{\dots}{additional arguments to be passed to and from methods.}

\item{method}{a character string specifying which plot to produce.
Possible values are \code{"dot"} for a dot plot of selected coefficients, or
\code{"density"} for a density plot of the indirect effect(s).}

\item{parm}{a character string specifying the coefficients to be included
in a dot plot.  The default is to include the direct and the indirect
effect(s).}

\item{data}{an optional numeric vector containing the \eqn{x}-values at
which to evaluate the assumed normal density from Sobel's test (only used in
case of a density plot).  The default is to take 100 equally spaced points
between the estimated indirect effect \eqn{\pm}{+/-} three times the
standard error according to Sobel's formula.}

\item{level}{numeric;  the confidence level of the confidence intervals
from Sobel's test to be included in a dot plot.  The default is to include
95\% confidence intervals.}

\item{mapping}{an aesthetic mapping to override the default behavior (see
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}).}

\item{facets}{a faceting formula to override the default behavior (only
used in case of a dot plot).  If supplied, \code{\link[ggplot2]{facet_wrap}}
or \code{\link[ggplot2]{facet_grid}} is called depending on whether the
formula is one-sided or two-sided.}
}
\value{
An object of class \code{"ggplot"} (see
\code{\link[ggplot2]{ggplot}}).
}
\description{
Produce dot plots of selected coefficients from regression models computed
in (robust) mediation analysis, or density plots of the indirect effect.
}
\examples{
data("BSG2014")

# run fast and robust bootstrap test
robust_boot <- test_mediation(BSG2014,
                              x = "ValueDiversity",
                              y = "TeamCommitment",
                              m = "TaskConflict",
                              robust = TRUE)

# create plots for robust bootstrap test
plot(robust_boot, method = "dot")
plot(robust_boot, method = "density")

# run standard bootstrap test
standard_boot <- test_mediation(BSG2014,
                                x = "ValueDiversity",
                                y = "TeamCommitment",
                                m = "TaskConflict",
                                robust = FALSE)

# compare robust and standard tests
tests <- list(Robust = robust_boot, Standard = standard_boot)
plot_mediation(tests, method = "dot")
plot_mediation(tests, method = "density")

}
\seealso{
\code{\link{test_mediation}},
\code{\link[=fortify.test_mediation]{fortify}}
}
\author{
Andreas Alfons
}
\keyword{hplot}
