% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_ci_plot.R
\name{setup_ci_plot}
\alias{setup_ci_plot}
\alias{setup_ci_plot.boot_test_mediation}
\alias{setup_ci_plot.sobel_test_mediation}
\alias{setup_ci_plot.list}
\title{Set up information for a dot plot with confidence intervals}
\usage{
setup_ci_plot(object, ...)

\method{setup_ci_plot}{boot_test_mediation}(object, parm = NULL,
  type = c("boot", "data"), ...)

\method{setup_ci_plot}{sobel_test_mediation}(object, parm = NULL,
  level = 0.95, ...)

\method{setup_ci_plot}{list}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class
\code{"\link{test_mediation}"} containing results from
(robust) mediation analysis, or a list of such objects.}

\item{\dots}{additional arguments to be passed down.}

\item{parm}{a character string specifying the effects to be included
in the plot.  The default is to include the direct and the indirect
effect(s).}

\item{type}{a character string specifying which point estiamates and
confidence intervals to plot: those based on the bootstrap distribution
(\code{"boot"}; the default), or those based on the original data
(\code{"data"}).  If \code{"boot"}, the confidence intervals of effects
other than the indirect effect(s) are computed using a normal approximation
(i.e., assuming a normal distribution of the corresponding effect with the
standard deviation computed from the bootstrap replicates).  If
\code{"data"}, the confidence intervals of effects other than the indirect
effect(s) are computed via statistical theory based on the original data
(e.g., based on a t-distribution the coefficients are estimated via
regression).  Note that this is only relevant for mediation analysis via a
bootstrap test, where the confidence interval of the indirect effect is
always computed via a percentile-based method due to the asymmetry of its
distribution.}

\item{level}{numeric;  the confidence level of the confidence intervals
from Sobel's test.  The default is to include 95\% confidence intervals.
Note that this is not used for bootstrap tests, as those require to specify
the confidence level already in \code{\link{test_mediation}()}.}
}
\value{
An object of class \code{"setup_ci_plot"} with the following
components:
\item{ci}{a data frame consisting of column \code{Effect} indicating the
different effects, column \code{Estimate} containing the point estimates,
column \code{Lower} for the lower confidence limit, and column \code{Upper}
for the upper confidence limit.  If a list of \code{"\link{test_mediation}"}
objects has been supplied, there is also a column \code{Method}, which takes
the names or indices of the list elements to indicate the different methods.}
\item{level}{numeric; the confidence level used for the confidence intervals
of the indirect effect(s).}
\item{have_methods}{a logical indicating whether a list of
\code{"\link{test_mediation}"} objects has been supplied.  If \code{TRUE},
the data frame in the \code{ci} component contains a column \code{Method}.}
}
\description{
Extract the relevant information for a dot plot with confidence intervals of
selected effects from (robust) mediation analysis.
}
\details{
This function is used internally by \code{\link{ci_plot}()}.  It may also
be useful for users who want to produce a similar plot, but who want more
control over what information to display or how to display that information.
}
\examples{
data("BSG2014")

# run fast and robust bootstrap test
robust_boot <- test_mediation(BSG2014,
                              x = "ValueDiversity",
                              y = "TeamCommitment",
                              m = "TaskConflict",
                              robust = TRUE)

# set up information for plot
setup <- setup_ci_plot(robust_boot, parm = "ab")

# plot only density and confidence interval
ggplot() +
  geom_hline(yintercept = 0, color = "darkgrey") +
  geom_pointrange(aes(x = "Robust bootstrap", y = Estimate,
                      ymin = Lower, ymax = Upper),
                  data = setup$ci) +
  labs(x = NULL, y = "Indirect effect")

}
\seealso{
\code{\link{test_mediation}()}, \code{\link{ci_plot}()}
}
\author{
Andreas Alfons
}
\keyword{hplot}
