% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robregcc.R
\name{cpsc_nsp}
\alias{cpsc_nsp}
\title{Principal sensitivity component analysis with compositional covariates in non-sparse setting.}
\usage{
cpsc_nsp(X0, y0, alp = 0.4, cfac = 2, b1 = 0.25, cc1 = 2.937,
  C = NULL, control = list())
}
\arguments{
\item{X0}{CLR transformed predictor matrix.}

\item{y0}{model response vector}

\item{alp}{(0,0.5) fraction of data sample to be removed to generate subsample}

\item{cfac}{initial value of shift parameter for weight construction/initialization}

\item{b1}{tukey bisquare function parameter producing desired breakdown point}

\item{cc1}{tukey bisquare function parameter producing desired breakdown point}

\item{C}{sub-compositional matrix}

\item{control}{a list of internal parameters controlling the model fitting}
}
\value{
\item{betaf}{TModel parameter estimate}
  \item{residuals}{residual estimate}
}
\description{
Produce model and its residual estimate based in PCS analysis.
}
\examples{
 

library(robregcc)
library(magrittr)

data(simulate_robregcc_nsp)
X <- simulate_robregcc_nsp$X;
y <- simulate_robregcc_nsp$y
C <- simulate_robregcc_nsp$C
n <- nrow(X); p <- ncol(X); k <-  nrow(C)

# Predictor transformation due to compositional constraint:
# Equivalent to performing centered log-ratio transform 
Xt <- svd(t(C))$u \%>\% tcrossprod() \%>\% subtract(diag(p),.) \%>\% crossprod(t(X),.)
#
Xm <- colMeans(Xt)
Xt <- scale(Xt,Xm,FALSE)                  # centering of predictors 
mean.y <- mean(y)
y <- y - mean.y                           # centering of response 
Xt <- cbind(1,Xt)                         # accounting for intercept in predictor
C <- cbind(0,C)                           # accounting for intercept in constraint
bw <- c(0,rep(1,p))                       # weight matrix to not penalize intercept 

example_seed <- 2*p+1               
set.seed(example_seed) 

# Breakdown point for tukey Bisquare loss function 
b1 = 0.5                    # 50\% breakdown point
cc1 =  1.567                # corresponding model parameter
# b1 = 0.25; cc1 =  2.937   

# Initialization [PSC analysis for compositional data]
control <- robregcc_option(maxiter=3000,tol = 1e-6)
fit.init  <- cpsc_nsp(Xt, y,alp=0.4,cfac=2,b1 = b1, cc1 = cc1,C,control)


}
\references{
Mishra, A., Mueller, C.,(2019) \emph{Robust regression with compositional covariates. In prepration}. arXiv:1909.04990.
}
