% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_gene_expression.R
\name{get.robust.markers}
\alias{get.robust.markers}
\title{Get Robust Marker}
\usage{
get.robust.markers(environment, cluster_group1, cluster_group2,
  group1_label, group2_label, annotate.genes = NA, min.fold.diff = 1.5,
  min.ratio.diff = 3, QValue = 0.05)
}
\arguments{
\item{environment}{\code{environment} object}

\item{cluster_group1}{cluster group 1 to be used as a foreground}

\item{cluster_group2}{cluster group 2 to be used as a background}

\item{group1_label}{label for group 1}

\item{group2_label}{label for group 2}

\item{annotate.genes}{specific gene names to annotate in figure in addition to novel markers}

\item{min.fold.diff}{average expression fold change cutoff}

\item{min.ratio.diff}{detection ratio fold change cutoff}

\item{QValue}{Qvalue cutoff}
}
\description{
Analysis of robust subpopulation marker prioritization
}
\examples{
\donttest{
LCMV1 <- setup_LCMV_example()
LCMV1 <- get.variable.genes(LCMV1, min.mean = 0.1, min.frac.cells = 0,
min.dispersion.scaled = 0.1)
LCMV1 <- PCA(LCMV1)
LCMV1 <- cluster.analysis(LCMV1)
diff_exp <- get.robust.markers(LCMV1,
cluster_group1 = c('1','2'),
cluster_group2 = c('3','4'),
group1_label = 'CD4 T Cells',
group2_label = 'CD8 T Cells')
}
}
