% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{read.data}
\alias{read.data}
\title{Read and Preprocess Data}
\usage{
read.data(environment, genome = "mm10", min.genes.per.cell = 500,
  max.genes.per.cell.quantile = 0.98,
  max.UMIs.per.cell.quantile = 0.98, min.cells.per.gene = 1,
  max.mitochondrial.frac = 0.1, max.ribosomal.frac = NA,
  cell.filters = NA, raw.data.matrices = NA, rerun = F,
  subsample = NULL, seed = 0)
}
\arguments{
\item{environment}{\code{environment} object}

\item{genome}{genome annotation}

\item{min.genes.per.cell}{minimum required number of genes per cell}

\item{max.genes.per.cell.quantile}{upper quantile for number of genes per cell}

\item{max.UMIs.per.cell.quantile}{upper quantile for number of UMIs per cell}

\item{min.cells.per.gene}{minimum required number of cells per gene}

\item{max.mitochondrial.frac}{maximum fraction of reads mapped to mitochondrial
genes per cell}

\item{max.ribosomal.frac}{maximum fraction of reads mapped to ribosomal genes per cell}

\item{cell.filters}{filtering option for cells based on marker genes}

\item{raw.data.matrices}{logical indicating if data matrices is provided instead of 10X dataset}

\item{rerun}{whether to rerun loading the dataset or load from cache}

\item{subsample}{number of cells to subsample}

\item{seed}{seed for subsampling of cells}
}
\description{
Read 10X data files or a raw data matrix and perform normalization, QC filtering and duplicates removal.
}
\examples{
LCMV1 <- setup_LCMV_example()
data.path <- system.file("extdata/LCMV1_small.txt", package = "robustSingleCell")
# name of list should be the same as LCMV1$datasets
raw_LCMV1 <- as.matrix(read.table(data.path, check.names = FALSE))
LCMV1 <- read.data(LCMV1,
raw.data.matrices = list(LCMV1 = raw_LCMV1),
min.genes.per.cell = 100,
max.genes.per.cell.quantile = 1,
max.UMIs.per.cell.quantile = 1,
min.cells.per.gene = 1)
}
