% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3.R
\name{sendStatement}
\alias{sendStatement}
\title{Send SQL statement to database.}
\usage{
sendStatement(db, statement, ...)
}
\arguments{
\item{db}{rocker object}

\item{statement}{SQL statement (\code{UPDATE, DELETE, INSERT INTO, ...})}

\item{...}{Optional, additional suitable parameters passed to \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}}
}
\value{
Invisible self
}
\description{
Send SQL statement to database.
}
\examples{
db <- rocker::newDB()
rocker::setupSQLite(db)
rocker::connect(db)
rocker::writeTable(db, "mtcars", mtcars)
rocker::sendStatement(db, "DELETE FROM mtcars WHERE gear = 3;")
rocker::clearResult(db)
rocker::disconnect(db)
rocker::unloadDriver(db)
}
