% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.r
\name{pull_model}
\alias{pull_model}
\alias{show_model}
\alias{delete_model}
\alias{copy_model}
\title{Pull, show and delete models}
\usage{
pull_model(model = NULL, server = NULL, insecure = FALSE)

show_model(model = NULL, server = NULL)

delete_model(model, server = NULL)

copy_model(model, destination = paste0(model, "-copy"), server = NULL)
}
\arguments{
\item{model}{name of the model. Defaults to "llama3" when \code{NULL} (except in
\code{delete_model}).}

\item{server}{URL to an Ollama server (not the API). Defaults to
"http://localhost:11434".}

\item{insecure}{allow insecure connections to the library. Only use this if
you are pulling from your own library during development. description}

\item{destination}{name of the copied model.}
}
\value{
(invisible) a tibble with information about the model (except in
\code{delete_model})
}
\description{
Pull, show and delete models
}
\details{
\itemize{
\item \code{pull_model()}: downloads model
\item \code{show_model()}: displays information about a local model
\item \code{copy_model()}: creates a model with another name from an existing model
\item \code{delete_model()}: deletes local model
}

\strong{Model names}: Model names follow a model:tag format, where model can have
an optional namespace such as example/model. Some examples are
orca-mini:3b-q4_1 and llama3:70b. The tag is optional and, if not provided,
will default to latest. The tag is used to identify a specific version.
}
\examples{
\dontrun{
model_info <- pull_model("mixtral")
# after you pull, you can get the same information with:
model_info <- show_model("mixtral")
}
}
