% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_grid_ahull_fill.R
\name{build_grid_ahull_fill}
\alias{build_grid_ahull_fill}
\title{Regular grid in alpha-hull}
\usage{
build_grid_ahull_fill(coords, npts, pad = NULL, grid_opts = list(alpha =
  0.3, error_tol = 0.05, run_max = 20, verbose = FALSE))
}
\arguments{
\item{coords}{A matrix or data.frame of coordinates with two columns}

\item{npts}{The approximate number of points of the requested grid}

\item{pad}{ignored argument}

\item{grid_opts}{A list with component \code{alpha}, \code{error_tol}, 
\code{run_max} and \code{verbose} that controls the
computation of the grid.}
}
\value{
The coordinates of a grid of points as a \code{data.frame} with
  approximately \code{npts} rows and \code{ncol(coords)} columns. Names
  are transfered from the \code{coords} data frame.
}
\description{
Create a grid within the alpha hull of a set of points.
}
\details{
This function computes the alpha hull of a set of points, then
  iteratively finds the best grid of \code{npts} points fitting in the hull.


This function computes the alpha hull of a set of points which is 
  an estimate of its overall outline. The intricateness of this outline 
  is determined by the \code{alpha} parameter: a value close to zero will 
  produce a very intricate outline and a high value will produce a coarse 
  outline (similar to the convex hull). It is highly recommended to try 
  different values of \code{alpha} to see what is most appropriate for one's
  datasets. 
  
  Parameter \code{error_tol} controls the acceptable relative error in the 
  grid number of points (e.g. 0.1 for 10%). \code{run_max} and \code{verbose}
  control the iteration process.
}
\examples{

data(meadow)

# Plot a grid with diagnostics
grid <- build_grid_ahull_fill(meadow[ ,c('lon','lat')], 10000,
                              grid_opts = list(verbose = TRUE))
plot(grid, pch = 21)

# See the influence of alpha parameter
par(mfrow = c(1, 4))
for ( alpha in c( .3, 1, 4, 10) ) {
  grid <- build_grid_ahull_fill(meadow[ ,c('lon','lat')], 10000,
                                grid_opts = list(alpha = alpha))
  plot(grid, pch = 21)
  title(paste0("alpha=",alpha))
}

}
\seealso{
\code{\link[alphahull]{ahull}}

Other grid.building.functions: \code{\link{build_grid_ahull_crop}},
  \code{\link{build_grid_identical}},
  \code{\link{build_grid_squaretile}}
}

