% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/works.R
\name{works}
\alias{works}
\title{Get works data}
\usage{
works(x)
}
\arguments{
\item{x}{Anything that can be coerced via \code{\link[=as.orcid]{as.orcid()}}, see
\code{\link[=as.orcid]{as.orcid()}} for help}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
A tibble (data.frame)
}
\description{
Get works data
}
\details{
This function gets works using the function \link{orcid_works}
and packages up the data in a data.frame for easier processing
}
\examples{
\dontrun{
out <- works(orcid_id("0000-0002-9341-7985"))
out
out$type
out$path

works( orcid_id("0000-0002-1642-628X") )
works( orcid_id("0000-0003-1444-9135") )
works( orcid_id("0000-0003-1419-2405") )

out <- orcid(query="keyword:ecology")
works(orcid_id(out$`orcid-identifier.path`[7]))
works(orcid_id(out$`orcid-identifier.path`[8]))
works(orcid_id(out$`orcid-identifier.path`[9]))
works(orcid_id(out$`orcid-identifier.path`[10]))
}
}
