% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossTab.R
\name{crossTab}
\alias{crossTab}
\alias{confIntV}
\alias{cramersV}
\alias{print.crossTab}
\alias{pander.crossTab}
\title{Cross tables}
\usage{
crossTab(x, y = NULL, conf.level = 0.95, digits = 2,
  pValueDigits = 3, ...)

\method{print}{crossTab}(x, digits = x$input$digits,
  pValueDigits = x$input$pValueDigits, ...)

\method{pander}{crossTab}(x, digits = x$input$digits,
  pValueDigits = x$input$pValueDigits, ...)
}
\arguments{
\item{x}{Either a crosstable to analyse, or one of two vectors to use to
generate that crosstable. The vector should be a factor, i.e. a categorical
variable identified as such by the 'factor' class).}

\item{y}{If x is a crosstable, y can (and should) be empty. If x is a
vector, y must also be a vector.}

\item{conf.level}{Level of confidence for the confidence interval.}

\item{digits}{Minimum number of digits after the decimal point to show in
the result.}

\item{pValueDigits}{Minimum number of digits after the decimal point to show
in the Chi Square p value in the result.}

\item{...}{Extra arguments to \code{crossTab} are passed on to
[ufs::confIntV()].}
}
\value{
The results of [ufs::confIntV()], but also prints the cross
table and the chi square test results.
}
\description{
This function produces a cross table, computes Chi Square, and computes the
point estimate and confidence interval for Cramer's V.
}
\examples{

crossTab(infert$education, infert$induced, samples=50);

}
\keyword{bivar}
