% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataReduction.R
\name{factorAnalysis}
\alias{factorAnalysis}
\alias{dataReduction}
\alias{principalComponentAnalysis}
\alias{rosettaDataReduction_partial}
\alias{knit_print.rosettaDataReduction}
\alias{print.rosettaDataReduction}
\title{Factor analysis or principal component analysis}
\usage{
factorAnalysis(
  data,
  nfactors,
  items = names(data),
  rotate = "oblimin",
  covar = FALSE,
  na.rm = TRUE,
  kaiser = 1,
  loadings = TRUE,
  summary = FALSE,
  correlations = FALSE,
  modelFit = FALSE,
  eigenValues = FALSE,
  screePlot = FALSE,
  residuals = FALSE,
  itemLabels = items,
  fm = "minres",
  digits = 2,
  headingLevel = 3,
  ...
)

principalComponentAnalysis(
  data,
  items,
  nfactors,
  rotate = "oblimin",
  covar = FALSE,
  na.rm = TRUE,
  kaiser = 1,
  loadings = TRUE,
  summary = FALSE,
  correlations = FALSE,
  eigenValues = FALSE,
  screePlot = FALSE,
  residuals = FALSE,
  itemLabels = items,
  digits = 2,
  headingLevel = 3,
  ...
)

rosettaDataReduction_partial(
  x,
  digits = x$input$digits,
  headingLevel = x$input$headingLevel,
  echoPartial = FALSE,
  partialFile = NULL,
  quiet = TRUE,
  ...
)

\method{knit_print}{rosettaDataReduction}(
  x,
  digits = x$input$digits,
  headingLevel = x$input$headingLevel,
  echoPartial = FALSE,
  partialFile = NULL,
  quiet = TRUE,
  ...
)

\method{print}{rosettaDataReduction}(
  x,
  digits = x$input$digits,
  headingLevel = x$input$headingLevel,
  forceKnitrOutput = FALSE,
  ...
)
}
\arguments{
\item{data}{The data frame that contains the \code{items}.}

\item{nfactors}{The number of factors to extract, or '\code{eigen}' to
extract all factors with an eigen value higher than the number
specified in \code{kaiser}. In the future, \code{parallel} can be specified
here to extract the number of factors suggested by parallel analysis.}

\item{items}{The items to analyse; if not specified, all variables
in \code{data} will be used.}

\item{rotate}{Which rotation to use; see \code{\link[psych:fa]{psych::fa()}} for all
options. The most common options are '\code{none}' to not rotate at all;
'\code{varimax}' for an orthogonal rotation (assuming/imposing that the
components or factors are not correlated); or '\code{oblimin}' for an
oblique rotation (allowing the components/factors to correlate).}

\item{covar}{Whether to analyse the correlation matrix (\code{FALSE}) or
the covariance matrix (\code{TRUE}).}

\item{na.rm}{Whether to first remove all cases with missing values.}

\item{kaiser}{The minimum eigenvalue when applying the Kaiser criterion (see
\code{nfactors}).}

\item{loadings}{Whether to display the component or factor loadings.}

\item{summary}{Whether to display the factor or component summary.}

\item{correlations}{Whether to display the correlations between
factors of components.}

\item{modelFit}{Whether to display the model fit Only for EFA).}

\item{eigenValues}{Whether to display the eigen values.}

\item{screePlot}{Whether to display the scree plot.}

\item{residuals}{Whether to display the matrix with residuals.}

\item{itemLabels}{Optionally, labels to use for the items (optionally, named,
with the names corresponding to the \code{items}; otherwise, the order of the
labels has to match the order of the items)}

\item{fm}{The method to use for the factor analysis: '\code{fm}' for Minimum
Residuals; '\code{ml}' for Maximum Likelihood; and '\code{pa}' for Principal Factor.}

\item{digits}{The number of digits to round to.}

\item{headingLevel}{The number of hashes to print in front of the headings
when printing while knitting}

\item{...}{Any additional arguments are passed to \code{\link[psych:fa]{psych::fa()}},
\code{\link[psych:principal]{psych::pca()}}, to the default print method by the print method, and to
\code{\link[rmdpartials:partial]{rmdpartials::partial()}} when knitting an RMarkdown partial.}

\item{x}{The object to print.}

\item{echoPartial}{Whether to show the executed code in the R Markdown
partial (\code{TRUE}) or not (\code{FALSE}).}

\item{partialFile}{This can be used to specify a custom partial file. The
file will have object \code{x} available.}

\item{quiet}{Passed on to \code{\link[knitr:knit]{knitr::knit()}} whether it should b
chatty (\code{FALSE}) or quiet (\code{TRUE}).}

\item{forceKnitrOutput}{Force knitr output.}
}
\value{
An object with the object resulting from the call to the
\code{psych} functions and some extracted information that will be printed.
}
\description{
This is a wrapper for the \code{psych} functions \code{\link[psych:principal]{psych::pca()}} and \code{\link[psych:fa]{psych::fa()}}
to produce output that it similar to the output produced by jamovi.
}
\details{
The code in these functions uses parts of the code in jamovi, written
by Jonathon Love and Ravi Selker.
}
\examples{
### Load example dataset
data("pp15", package="rosetta");

### Get variable names with expected
### effects of a high dose of MDMA
items <-
  grep(
    "highDose_AttBeliefs_",
    names(pp15),
    value=TRUE
  );

### Do a factor analysis
rosetta::factorAnalysis(
  data = pp15,
  items = items,
  nfactors = "eigen"
);

\dontrun{
### To get more output and show the
### output as Rmd Partial in the viewer
rosetta::rosettaDataReduction_partial(
  rosetta::factorAnalysis(
    data = pp15,
    items = items,
    nfactors = "eigen",
    summary = TRUE,
    correlations = TRUE,
    scree = TRUE
  )
);
}

}
