% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptiveCIs.R
\name{descriptiveCIs}
\alias{descriptiveCIs}
\alias{print.rosettaDescriptiveCIs}
\title{Descriptives with confidence intervals}
\usage{
descriptiveCIs(
  data,
  items = NULL,
  itemLabels = NULL,
  conf.level = 0.95,
  digits = 2
)

\method{print}{rosettaDescriptiveCIs}(x, digits = attr(x, "digits"), forceKnitrOutput = FALSE, ...)
}
\arguments{
\item{data}{The data frame holding the data, or a vector.}

\item{items}{If supplying a data frame as \code{data}, the names of the
columns to process.}

\item{itemLabels}{Optionally, labels to use for the items (optionally, named,
with the names corresponding to the \code{items}; otherwise, the order of the
labels has to match the order of the items)}

\item{conf.level}{The confidence level of the confidence intervals.}

\item{digits}{The number of digits to round the output to.}

\item{x}{The object to print (i.e. the object returned by \code{descriptiveCIs}).}

\item{forceKnitrOutput}{Whether to force \code{knitr} output even when
not knitting.}

\item{...}{Any additional arguments are passed on to \code{\link[knitr:kable]{knitr::kable()}} or to
\code{\link[base:print]{base::print()}}.}
}
\value{
A data frame with class \code{rosettaDescriptiveCIs} prepended to allow
printing neatly while knitting to Markdown.
}
\description{
Descriptives with confidence intervals
}
\examples{
descriptiveCIs(mtcars);
}
