% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bingmaps.R
\name{bmaps.plot}
\alias{bmaps.plot}
\title{Plot Bing Maps}
\usage{
bmaps.plot(bbox, type = "Aerial", key = NULL, ...)
}
\arguments{
\item{bbox}{A bounding box as generated by \code{sp::bbox()} or \code{prettymapr::searchbbox()}}

\item{type}{Use \code{Aerial}, \code{AerialWithLabels}, or \code{Road}.}

\item{key}{If plotting a large number of images, consider getting your own (free) key at
the \href{https://msdn.microsoft.com/en-us/library/ff428642.aspx}{Microsoft Website}.}

\item{...}{Arguments passed on to \link{osm.plot}.}
}
\description{
Identical syntax to \link{osm.plot}, but using Bing maps (\url{https://www.bing.com/maps/})
instead of Open Street Map.
}
\examples{
\donttest{
library(prettymapr)
bmaps.plot(makebbox(47.2, -59.7, 43.3, -66.4))
bmaps.plot(makebbox(47.2, -59.7, 43.3, -66.4), type="Road")
}

}

