% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxygenize.R
\name{roxygenize}
\alias{roxygenize}
\alias{roxygenise}
\title{Process a package with the Rd, namespace and collate roclets.}
\usage{
roxygenize(package.dir = ".", roclets = NULL, load_code = source_package,
  clean = FALSE)

roxygenise(package.dir = ".", roclets = NULL, load_code = source_package,
  clean = FALSE)
}
\arguments{
\item{package.dir}{Location of package top level directory. Default is
working directory.}

\item{roclets}{Character vector of roclet names to use with package.
This defaults to \code{NULL}, which will use the \code{roclets} fields in
the list provided in the \code{Roxygen} DESCRIPTION field. If none are
specified, defaults to \code{c("collate", "namespace", "rd")}.}

\item{load_code}{A function used to load all the R code in the package
directory. It is called with the path to the package, and it should return
an environment containing all the sourced code.}

\item{clean}{If \code{TRUE}, roxygen will delete all files previously
created by roxygen before running each roclet.}
}
\value{
\code{NULL}
}
\description{
This is the workhorse function that uses roclets, the built-in document
tranformation functions, to build all documentation for a package.  See
the documentation for the individual roclets, \code{\link[=rd_roclet]{rd_roclet()}},
\code{\link[=namespace_roclet]{namespace_roclet()}}, and for \code{\link[=update_collate]{update_collate()}},
for more details.
}
\details{
Note that roxygen2 is a dynamic documentation system: it works using
by inspecting loaded objects in the package. This means that you must
be able to load the package in order to document it.
\code{\link[=source_package]{source_package()}} provides a simple simulation of package
loading that works if you only have R files in your package. For more
complicated packages, I recommend using \code{devtools::document} which
does a much better job at simulating package install and load.
}
