% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{markdownify}
\alias{markdownify}
\title{Convert text to Markdown}
\usage{
markdownify(text, scope = c("full", "simple", "none"))
}
\arguments{
\item{text}{A character vector containing \code{.Rd} style annotations.}

\item{scope}{The scope of transformations: \code{"simple"} runs only transformations
that shouldn't substantially change the resulting \code{.Rd} files, \code{"full"} runs
all transformations. In larger packages, run \code{"none"}, double-check and track
the changes, and then run \code{"simple"} and then \code{"full"}.}
}
\value{
The same vector with \code{.Rd} style annotations converted to Markdown
style annotations.
}
\description{
Converts a character vector from Rd to Markdown.

With \code{scope = "none"}, no transformations are carried out.

With \code{scope = "simple"}, the following elements are converted:
\itemize{
\item \code{\\code{}}
\item \code{\\emph{}}
\item \code{\\bold{}} and \code{\\strong{}}
\item \code{\\href{}}
\item \code{\\url{}}
}

With \code{scope = "full"}, the following elements are converted in addition:

\itemize{
\item \code{\\code{\\link{}}} and \code{\\link{}}, with \code{[]} options
\item \code{\\linkS4class{}}
}
}
\examples{
text <- c(
  "Both \\\\emph{italics} and \\\\bold{bold} text.",
  paste0("We can also convert code: \\\\", "code{\\\\", "link{identity}}.")
)

text
markdownify(text)

}
