% Generated by roxygen2 (4.0.2): do not edit by hand
\name{SitemFit}
\alias{SitemFit}
\title{Compute the S fit statistic for a set of items}
\usage{
SitemFit(grp, ..., method = "pearson", log = TRUE, qwidth = 6,
  qpoints = 49L, alt = FALSE, omit = 0L, .twotier = TRUE)
}
\arguments{
\item{grp}{a list with spec, param, mean, cov, data, and the free variable pattern}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{method}{whether to use a pearson or rms test}

\item{log}{whether to return pvalues in log units}

\item{qwidth}{the positive width of the quadrature in Z units}

\item{qpoints}{the number of quadrature points}

\item{alt}{whether to include the item of interest in the denominator}

\item{omit}{number of items to omit (a single number) or a list of the length the number of items}

\item{.twotier}{whether to enable the two-tier optimization}
}
\value{
a list of output from \code{\link{SitemFit1}}
}
\description{
Runs \code{\link{SitemFit1}} for every item and accumulates
the results.
}
\examples{
grp <- list(spec=list())
grp$spec[1:20] <- rpf.grm()
grp$param <- sapply(grp$spec, rpf.rparam)
colnames(grp$param) <- paste("i", 1:20, sep="")
grp$mean <- 0
grp$cov <- diag(1)
grp$free <- grp$param != 0
grp$data <- rpf.sample(500, grp=grp)
SitemFit(grp)
}

