\name{[.msa}
\alias{[.msa}
\title{Extract, replace, reorder MSA...}
\usage{\method{[}{msa}(x, rows, cols, pointer.only)}
\description{Extract, replace, reorder MSA}
\details{Treat multiple sequence alignment as a matrix where each row
corresponds to a sequence for one species, and each column
is one position aligned across all species.

The bracket notation can return a subset of the alignment,
or re-order rows and columns.}
\seealso{\code{\link{sub.msa}} which can subset columns based on genomic
coordinates, and \code{\link{extract.feature.msa}} which can subset based
on genomic coordinates denoted in a features object.}
\note{This function will not alter the value of x even if it is stored as
a pointer to a C structure.}
\keyword{msa}
\arguments{\item{x}{An object of type \code{msa}}
\item{rows}{A numeric vector of sequence indices,
character vector (containing sequence name), or
logical vector (containing sequences to keep).  If logical vector it
will be recycled as necessary to the same length as \code{nrow.msa(x)}.}
\item{cols}{A numeric vector of alignment columns, or a logical vector
containing columns to keep.  If logical vector it will be recycled as
necessary to the same length as \code{ncol.msa(x)}.  Note that these are
in coordinates with respect to the entire alignment.  x$idx.offset
is ignored here.}
\item{pointer.only}{If \code{TRUE}, return an object which is only
a pointer to a structure stored in C (useful for large alignments;
advanced use only).  In certain cases when the original alignment
is stored in R, it may be more efficient return an object in R, in which
case this argument will be ignored.}}
\examples{
require("rphast")
m <- msa(seqs=c("ACGTAT", "AGGTAA", "AGGTAG"),
         names=c("human", "mouse", "rat"))
print(m[c("rat", "rat", "human"), ], print.seq=TRUE)
print(m[c(3,3,1),], print.seq=TRUE)
print(m[c(TRUE, FALSE, TRUE),], print.seq=TRUE)
print(m[TRUE,], print.seq=TRUE)
print("[.msa"(m, "mouse",c(1,6,3,5)), print.seq=TRUE)
}
\author{Melissa Hubisz <mjhubisz@cornell.edu> and Adam Siepel
    <acs4@cornell.edu>}
