\name{get4d.msa}
\alias{get4d.msa}
\title{Extract fourfold degenerate sites from an MSA object}
\usage{
  get4d.msa(x, features)
}
\arguments{
  \item{x}{An object of type \code{msa}}

  \item{features}{an object of type \code{feat}.  Should
  have defined coding regions with feature type "CDS"}
}
\value{
  An unordered msa object containing only the sites which
  are fourfold degenerate.
}
\description{
  Extract fourfold degenerate sites from an MSA object
}
\note{
  \itemize{ {If x is stored as a pointer, it will be
  reduced to four-fold degenerate sites, so the original
  alignment will be lost.  Use get4d.msa(copy.msa(x),
  features) to avoid this behavior.  The return value will
  always be stored in R regardless of how the original
  alignment was stored.} \item{For very large MSA objects
  it is more efficient to use the do.4d option in the
  read.msa function instead.}}
}
\examples{
exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
files <- c("ENr334-100k.maf", "ENr334-100k.fa", "gencode.ENr334-100k.gff")
unzip(exampleArchive, files)
f <- read.feat("gencode.ENr334-100k.gff")
f$seqname <- "hg18.chr6"
m1 <- read.msa("ENr334-100k.maf", features=f, do.4d=TRUE)
m2 <- read.msa("ENr334-100k.maf")
m3 <- get4d.msa(m2, features=f)
m4 <- get4d.msa(read.msa("ENr334-100k.maf"), features=f)
m5 <- get4d.msa(read.msa("ENr334-100k.fa", offset=41405894), features=f)
unlink(files)
}
\author{
  Melissa J. Hubisz and Adam Siepel
}

