\name{is.format.msa}
\alias{is.format.msa}
\title{Check an MSA Format String}
\usage{
  is.format.msa(format)
}
\arguments{
  \item{format}{a character vector of strings to test}
}
\value{
  a logical vector indicating whether each element of the
  input parameter is a valid format string.
}
\description{
  Returns TRUE if the argument is a valid string describing
  a multiple sequence alignment (MSA) format.
}
\details{
  Valid formats include "FASTA", "PHYLIP", "SS" (Sufficient
  statistics format used by PHAST), "MPM" (format used by
  MultiPipMaker), "LAV" (used by blastz), or "MAF"
  (Multiple Alignment Format used by MULTIZ and TBA.
}
\examples{
is.format.msa(c("MAF", "SS", "PHYLIP", "MPM", "LAV", "FASTA",
                "BAD_FORMAT_STRING"))
}
\author{
  Melissa J. Hubisz
}
\keyword{msa}

