\name{unique.feat}
\alias{unique.feat}
\title{Remove overlapping genes}
\usage{
  \method{unique}{feat} (x, incomparables = FALSE, ...)
}
\arguments{
  \item{x}{An object of type \code{feat}, usually read from
  a genepred file.  Should have attributes labelled
  "transcript_id" which identify features belonging to the
  same gene.}

  \item{incomparables}{Not currently used (present for S3
  compatibility).}

  \item{...}{Not currently used.}
}
\value{
  An object of type \code{feat} with overlapping genes
  removed. If the features are scored, then the feature
  with the highest score is kept; otherwise the feature
  with the longest length.  If x is a pointer to an object
  stored in C, the return value will also be a pointer (and
  x will be altered to the return value).
}
\description{
  Remove overlapping genes
}
\note{
  \itemize{ \item{Long UTRs can have undesirable effects;
  may want to filter these out first.} \item{If x is a
  pointer to an object in C, it will be modified (to the
  return value).}}

  VERY IMPORTANT: this function is not currently
  implemented to look at chromosomes (ie the seqname field
  of the feature).  Therefore any genes which have
  overlapping coordinates REGARDLESS OF THE CHROMOSOME will
  be pruned to a single "non-overlapping" gene.  To get
  around this, first subset the features by chromosome and
  call uniq.feat on each subset.

  Also, this algorithm considers genes to be overlapping
  even if they are on different strands.  If this is
  undesirable, then subset the features by strand as well
  as chromosome.
}
\author{
  Melissa J. Hubisz and Adam Siepel
}
\keyword{features}

