% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citations.R
\name{citations}
\alias{citations}
\title{Search PLOS Rich Citations API}
\usage{
citations(uri = NULL, doi = NULL, parse = FALSE, ...)
}
\arguments{
\item{uri}{(character) A URI, of the form \code{http://dx.doi.org/<DOI>}}

\item{doi}{(character) A PLOS journals DOI}

\item{parse}{(logical) Passed to \code{\link[jsonlite]{fromJSON}}, toggles
whether we return json parsed to data.frame's where possible, or not.
Default: FALSE}

\item{...}{Curl options passed to \code{\link[httr]{GET}}}
}
\value{
A list
}
\description{
Search PLOS Rich Citations API
}
\details{
To get an API key, email \email{ploslabs@plos.org} and request a key
}
\examples{
\dontrun{
# get citations for an article (via its DOI)
uri <- "http://dx.doi.org/10.1371\%2Fjournal.pone.0000000"
citations(uri)
citations(uri, parse = TRUE)

# pass in a DOI, url encoded or not
citations(doi = "10.1371\%2Fjournal.pone.0000000")
citations(doi = "10.1371/journal.pone.0000000")
ids <- searchplos(q='ecology', fl='id', limit = 20)$data$id
citations(doi = ids[1])
}
}
\references{
\url{http://api.richcitations.org/}
}

