% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevalence.R
\name{prevalence_counted}
\alias{prevalence_counted}
\title{Count prevalence from registry data.}
\usage{
prevalence_counted(entry, eventdate, status, index_date = NULL,
  num_reg_years = NULL, start = NULL)
}
\arguments{
\item{entry}{Vector of diagnosis dates for each patient in the registry in
the format YYYY-MM-DD.}

\item{eventdate}{Vector of dates corresponding to the indicator variable in
the format YYYY-MM-DD.}

\item{status}{Vector of binary values indicating if an event has occurred for
each patient in the registry. \code{entry}, \code{eventdate}, and
\code{status} must all have the same length.}

\item{index_date}{The date at which to estimate point prevalence. Defaults to the
latest registry entry date.}

\item{num_reg_years}{The number of years of the registry for which incidence
is to be calculated. Defaults to using all available complete years. Note
that if more registry years are supplied than the number of years to
estimate prevalence for, the survival data from the surplus registry years
are still involved in the survival model fitting.}

\item{start}{\strong{Deprecated: Use \code{index_date} instead and specify the
number of years of registry data to use with \code{num_reg_years}.}
Date from which incident cases are included in the format YYYY-MM-DD. Defaults
to the earliest entry date. This value is now inferred by counting back
\code{num_reg_years} years of registry data from the \code{index_date}. and}
}
\value{
A vector of length equal to the number of complete years of registry data
  before \code{index_date} (given by \code{num_reg_years}), representing the number of
  incident cases in the corresponding year that contribute to the prevalence
  at the index date.
}
\description{
Counts contribution to prevalence at a specific index from each year of a
registry. A person is included as contributing to disease prevalence if they
are incident within the specified time-span, and are either alive or censored
at the index date. The rationale for including censored cases in prevalence
estimation is that such cases have typically been lost to follow-up, and are
often more likely to have been alive at the index date than not.
}
\examples{
data(prevsim)

prevalence_counted(prevsim$entrydate,
                   prevsim$eventdate,
                   prevsim$status)

prevalence_counted(prevsim$entrydate,
                   prevsim$eventdate,
                   prevsim$status,
                   index_date="2012-01-30")

}
\seealso{
Other prevalence functions: \code{\link{prevalence_simulated}},
  \code{\link{prevalence}},
  \code{\link{test_prevalence_fit}}
}

