% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{population_survival_rate}
\alias{population_survival_rate}
\title{Transform yearly mortality rates to daily.}
\usage{
population_survival_rate(form, data, max_age = 100)
}
\arguments{
\item{form}{Formula where the LHS indicates the name of the mortality rate
column, and the RHS is the column where age is located. This function
assumes that the population data frame has already been stratified by sex,
or any other categorical variable of interest.}

\item{data}{Data frame of population mortality stratified by sex and age. The
following columns must be present: \code{sex}, \code{age}, and \code{rate}.}

\item{max_age}{Maximum age to calculate mortality for.}
}
\value{
An estimate of the survival rate by age in days, with \code{max_age}
  * DAYS_IN_YEAR values.
}
\description{
Calculates the daily mortality probability for a given population stratified
by age, based on their yearly mortality rates.
}
\examples{
data(UKmortality)

population_survival_rate(rate ~ age, UKmortality)
population_survival_rate(rate ~ age, subset(UKmortality, sex==0))

}
