% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_model.R
\name{predict_survival_probability}
\alias{predict_survival_probability}
\title{Predicts survival probability for given individuals at specific times.}
\usage{
predict_survival_probability(object, newdata, times)
}
\arguments{
\item{object}{The survival object itself}

\item{newdata}{Simulated incident individuals, with the same attributes specified in
\code{extract_covars} and found in the supplied registry data to \code{prevalence}.}

\item{times}{The time at which to estimate the survival probability of the individual
in the corresponding row of \code{newdata}. Must have as many times as \code{newdata}
has rows.}
}
\value{
A vector with the same length as \code{times} providing the survival probability
  estimates.
}
\description{
This generic method is required for any survival object used in the main
\code{prevalence} function.
}
