% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rpt.R
\name{print.rpt}
\alias{print.rpt}
\title{Print a rpt object}
\usage{
\method{print}{rpt}(x, ...)
}
\arguments{
\item{x}{An rpt object returned from one of the rpt functions}

\item{\dots}{Additional arguments; none are used in this method.}
}
\value{
Abbreviations in the print.rpt output:
\item{R}{Repeatability.}
\item{SE}{Standard error of R.}
\item{CI}{Confidence interval of R derived from parametric bootstrapping.}
\item{P}{P-value}
\item{LRT}{Likelihood-ratio test}
\item{Permutation}{Permutation of residuals}
}
\description{
Displays the results a rpt object (i.e. the result of a rpt function call) in a nice form.
}
\references{
Nakagawa, S. & Schielzeth, H. (2010) \emph{Repeatability for Gaussian and 
             non-Gaussian data: a practical guide for biologists}. Biological Reviews 85: 935-956
}
\author{
Holger Schielzeth  (holger.schielzeth@uni-jena.de), 
        Shinichi Nakagawa (s.nakagawa@unsw.edu.au),
        Martin Stoffel (martin.adam.stoffel@gmail.com)
}
\keyword{models}
