% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relop_extend.R
\name{ex_data_table.relop_extend}
\alias{ex_data_table.relop_extend}
\title{Implement extend/assign operator.}
\usage{
\method{ex_data_table}{relop_extend}(optree, ..., tables = list(),
  source_usage = NULL, source_limit = NULL, env = parent.frame())
}
\arguments{
\item{optree}{relop operations tree.}

\item{...}{not used, force later arguments to bind by name.}

\item{tables}{named list map from table names used in nodes to data.tables and data.frames.}

\item{source_usage}{list mapping source table names to vectors of columns used.}

\item{source_limit}{if not null limit all table sources to no more than this many rows (used for debugging).}

\item{env}{environment to work in.}
}
\description{
\code{data.table} based implementation.
}
\details{
Will re-order columns if there are ordering terms.
}
\examples{

dL <- build_frame(
    "subjectID", "surveyCategory"     , "assessmentTotal", "one" |
    1          , "withdrawal behavior", 5                , 1     |
    1          , "positive re-framing", 2                , 1     |
    2          , "withdrawal behavior", 3                , 1     |
    2          , "positive re-framing", 4                , 1     )
rquery_pipeline <- local_td(dL) \%.>\%
  extend_nse(.,
             probability \%:=\%
               exp(assessmentTotal * 0.237)/
               sum(exp(assessmentTotal * 0.237)),
             count \%:=\% sum(one),
             rank \%:=\% rank(),
             orderby = c("assessmentTotal", "surveyCategory"),
             reverse = c("assessmentTotal"),
             partitionby = 'subjectID') \%.>\%
  orderby(., c("subjectID", "probability"))
ex_data_table(rquery_pipeline)

}
