% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Entry.R
\docType{class}
\name{Entry-class}
\alias{Entry-class}
\alias{Entry}
\title{Class "Entry"}
\description{
Class \code{Entry} is responsible for creating assessment tasks according to the
QTI 2.1 standard. These tasks include one or more instances of text input
fields (with numeric or text answers) or dropdown lists.
}
\section{Slots}{

\describe{
\item{\code{identifier}}{A character representing the unique identifier of the
assessment task. By default, it is generated as 'id_task_dddd', where dddd
represents random digits.}

\item{\code{title}}{A character representing the title of the XML file associated
with the task. By default, it takes the value of the identifier.}

\item{\code{content}}{A list of character content to form the text of the question,
which can include HTML tags. For tasks of the \link{Entry} type, it must also
contain at least one instance of Gap objects, such as \linkS4class{TextGap},
\link{NumericGap}, or \link{InlineChoice}.}

\item{\code{prompt}}{An optional character representing a simple question text,
consisting of one paragraph. This can supplement or replace content in the
task. Default is "".}

\item{\code{points}}{A numeric value, optional, representing the number of points for
the entire task. Default is 1, but pay attention:
\itemize{
\item For tasks of the \link{Entry} type, it is
calculated as the sum of the gap points by default.
\item For tasks of the \link{MatchTable} type, it can also be calculated as the sum
of points for individual answers, when provided.
\item For tasks of the \link{MultipleChoice} type, points is numeric vector and
required. Each number in this vector determines the number of points that
will be awarded to a candidate if they select the corresponding answer. The
order of the scores must match the order of the \code{choices}. It is possible
to assign negative values to incorrect answers. All answers with a
positive score are considered correct.
}}

\item{\code{feedback}}{A list containing feedback messages for candidates. Each
element of the list should be an instance of either \link{ModalFeedback},
\link{CorrectFeedback}, or \link{WrongFeedback} class.}

\item{\code{calculator}}{A character, optional, determining whether to show a
calculator to the candidate. Possible values:
\itemize{
\item "simple-calculator"
\item "scientific-calculator"
}}

\item{\code{files}}{A character vector, optional, containing paths to files that will
be accessible to the candidate during the test/exam.}

\item{\code{qti_version}}{A character representing the QTI (Question and Test
Interoperability) information model version. Default is 'v2p1'.}
}}

\examples{
entry_gaps <- new("Entry", content = list("<p>In mathematics, the common
logarithm is the logarithm with base", new("NumericGap",
                                           response_identifier = "numeric_1",
                                           solution = 10,
                                           placeholder = "it is a number"),
". It is also known as the decimal", new("TextGap",
                                         response_identifier = "text_1",
                                         solution = "logarithm",
                                         placeholder = "it is a text"),
 ".</p>"),
                   title = "entry with number and text in answers",
                   identifier = "entry_example")
entry_dropdown <- new("Entry", content = list("<p>In mathematics, the common
logarithm is the logarithm with base", new("InlineChoice",
                                           response_identifier = "numeric_1",
                                           choices = c("10", "7", "11")),
". It is also known as the decimal", new("InlineChoice",
                                         response_identifier = "text_1",
                                         choices = c("logarithm", "limit")),
 ".</p>"),
                   title = "entry with dropdown lists for answers",
                   identifier = "entry_example")
}
\seealso{
\link{NumericGap}, \link{TextGap}, \link{InlineChoice}
}
