% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlook.R
\name{rstr}
\alias{rstr}
\alias{rlook}
\title{Quick look at remote data}
\usage{
rstr(
  my_db,
  tableName,
  ...,
  displayRows = 10,
  countRows = TRUE,
  qualifiers = NULL
)

rlook(
  my_db,
  tableName,
  ...,
  displayRows = 10,
  countRows = TRUE,
  qualifiers = NULL
)
}
\arguments{
\item{my_db}{database handle}

\item{tableName}{name of table to look at}

\item{...}{not used, force later arguments to bind by name}

\item{displayRows}{number of rows to sample}

\item{countRows}{logical, if TRUE return row count.}

\item{qualifiers}{optional named ordered vector of strings carrying additional db hierarchy terms, such as schema.}
}
\value{
str view of data
}
\description{
Quick look at remote data
}
\examples{

if ( requireNamespace("DBI", quietly = TRUE) &&
  requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  DBI::dbWriteTable(my_db,
                    'd',
                    data.frame(AUC = 0.6, R2 = 0.2),
                    overwrite = TRUE,
                    temporary = TRUE)
  rlook(my_db, 'd')
  DBI::dbDisconnect(my_db)
}

}
