% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadoc.R
\docType{data}
\name{amino}
\alias{amino}
\title{Amino acids fluorescence data.}
\format{
A three-way array with dimension \code{5x201x61}.
 The first dimension refers to the 5 samples. The second dimension
 refers to the emission measurements (250-450nm, 1nm intervals).
 The third dimension refers to the excitation (240-300 nm, 1nm intervals).
}
\source{
\url{https://ucphchemometrics.com/datasets/}.
}
\usage{
data(amino)
}
\description{
A data set containing five simple laboratory-made samples where each sample contains
 different amounts of tyrosine, tryptophan and phenylalanine dissolved in phosphate
 buffered water. The samples were measured by fluorescence (excitation 240-300 nm,
 emission 250-450 nm, 1 nm intervals) on a PE LS50B spectrofluorometer.
}
\examples{
 \dontrun{

 data(amino)
 ##  Plotting Emission spectra
 oldpar <- par(mfrow=c(2,1))
 matplot(t(amino[,,1]), type="l",
     xlab="Wavelength/nm", ylab="Intensity",
     main="Fluorescence emission spectra")
 matplot(t(amino[,,5]), type="l",
     xlab="Wavelength/nm", ylab="Intensity",
     main="Fluorescence emission spectra")
 par(oldpar)

 ##  Plotting excitation spectra
 oldpar <- par(mfrow=c(2,1))
 matplot(t(amino[,1,]), type="l",
     xlab="Wavelength/nm", ylab="Intensity",
     main="Fluorescence excitation spectra")
 matplot(t(amino[,30,]), type="l",
     xlab="Wavelength/nm", ylab="Intensity",
     main="Fluorescence excitation spectra")
 par(oldpar)

}
}
\references{
Bro, R, PARAFAC: Tutorial and applications, Chemometrics and Intelligent Laboratory Systems, 1997, 38, 149-171
 Bro, R, Multi-way Analysis in the Food Industry. Models, Algorithms, and Applications. 1998. Ph.D. Thesis,
     University of Amsterdam (NL) & Royal Veterinary and Agricultural University (DK).
 Kiers, H.A.L. (1998) A three-step algorithm for Candecomp/Parafac analysis of large data
     sets with multicollinearity, Journal of Chemometrics, 12, 155-171.
}
\keyword{datasets}
