/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction1;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import org.openjena.atlas.lib.StrUtils;

public class E_StrEncodeForURI
extends ExprFunction1 {
    private static final String symbol = "encode_for_uri";
    static char[] reserved = new char[]{' ', '!', '*', '\"', '\'', '(', ')', ';', ':', '@', '&', '=', '+', '$', ',', '/', '?', '%', '#', '[', ']'};
    char[] other = new char[]{'<', '>', '~', '.', '{', '}', '|', '\\', '-', '`', '_', '^'};
    char[] all = new char[]{' ', '!', '*', '\"', '\'', '(', ')', ';', ':', '@', '&', '=', '+', '$', ',', '/', '?', '%', '#', '[', ']', '<', '>', '~', '.', '{', '}', '|', '\\', '-', '`', '_', '^'};

    public E_StrEncodeForURI(Expr expr) {
        super(expr, symbol);
    }

    public NodeValue eval(NodeValue v) {
        String str2 = E_StrEncodeForURI.plainString(v);
        String encStr = StrUtils.encodeHex(str2, '%', this.all);
        return NodeValue.makeString(encStr);
    }

    static String plainString(NodeValue v) {
        Node n = v.asNode();
        if (n.getLiteralLanguage() != null && !n.getLiteralLanguage().equals("")) {
            throw new ExprEvalException("Not allowed: RDF term with a language tag");
        }
        if (!n.isLiteral()) {
            throw new ExprEvalException("Not a literal");
        }
        if (n.getLiteralDatatype() != null && !XSDDatatype.XSDstring.equals(n.getLiteralDatatype())) {
            throw new ExprEvalException("Not a simple literal nor an XSD string");
        }
        return n.getLiteralLexicalForm();
    }

    public Expr copy(Expr expr) {
        return new E_StrEncodeForURI(expr);
    }
}

