/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.tdb.StoreConnection;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.setup.DatasetBuilderStd;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.TDBInternal;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTransaction;

public class TDBMaker {
    private static DatasetGraphMakerTDB builder = new BuilderStd();

    public static DatasetGraphTransaction createDatasetGraphTransaction(String location) {
        return TDBMaker.createDatasetGraphTransaction(new Location(location));
    }

    public static DatasetGraphTransaction createDatasetGraphTransaction(Location location) {
        return TDBMaker._create(location);
    }

    public static DatasetGraphTransaction createDatasetGraphTransaction() {
        return TDBMaker.createDatasetGraphTransaction(Location.mem());
    }

    private static DatasetGraphTransaction _create(Location location) {
        return new DatasetGraphTransaction(location);
    }

    public static void releaseLocation(Location location) {
        StoreConnection.release(location);
    }

    public static void reset() {
        StoreConnection.reset();
    }

    public static DatasetGraphTDB createDatasetGraphTDB(Location loc) {
        return builder.createDatasetGraph(loc);
    }

    private static class BuilderStoreConnectionBase
    implements DatasetGraphMakerTDB {
        private BuilderStoreConnectionBase() {
        }

        @Override
        public DatasetGraphTDB createDatasetGraph(Location location) {
            return StoreConnection.make(location).getBaseDataset();
        }
    }

    private static class BuilderBase
    implements DatasetGraphMakerTDB {
        private BuilderBase() {
        }

        @Override
        public DatasetGraphTDB createDatasetGraph(Location location) {
            DatasetGraph dsg = TDBFactory.createDatasetGraph(location);
            return TDBInternal.getBaseDatasetGraphTDB(dsg);
        }
    }

    private static class BuilderStd
    implements DatasetGraphMakerTDB {
        private BuilderStd() {
        }

        @Override
        public DatasetGraphTDB createDatasetGraph(Location location) {
            return DatasetBuilderStd.build(location);
        }
    }

    private static interface DatasetGraphMakerTDB {
        public DatasetGraphTDB createDatasetGraph(Location var1);
    }
}

