/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunction;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionFactory;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionFactoryAuto;
import com.hp.hpl.jena.sparql.pfunction.library.container;
import com.hp.hpl.jena.sparql.pfunction.library.listIndex;
import com.hp.hpl.jena.sparql.pfunction.library.listLength;
import com.hp.hpl.jena.sparql.pfunction.library.listMember;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.MappedLoader;
import com.hp.hpl.jena.sparql.vocabulary.ListPFunction;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.logging.Log;

public class PropertyFunctionRegistry {
    static PropertyFunctionRegistry globalRegistry = null;
    Map<String, PropertyFunctionFactory> registry = new HashMap<String, PropertyFunctionFactory>();
    Set<String> attemptedLoads = new HashSet<String>();

    public static synchronized PropertyFunctionRegistry standardRegistry() {
        PropertyFunctionRegistry reg = new PropertyFunctionRegistry();
        reg.loadStdDefs();
        return reg;
    }

    public static PropertyFunctionRegistry get(Context context) {
        if (context == null) {
            return null;
        }
        return (PropertyFunctionRegistry)context.get(ARQConstants.registryPropertyFunctions);
    }

    public static PropertyFunctionRegistry chooseRegistry(Context context) {
        PropertyFunctionRegistry registry = PropertyFunctionRegistry.get(context);
        if (registry == null) {
            registry = PropertyFunctionRegistry.get();
        }
        return registry;
    }

    public static void set(Context context, PropertyFunctionRegistry reg) {
        context.set(ARQConstants.registryPropertyFunctions, reg);
    }

    public static synchronized PropertyFunctionRegistry get() {
        PropertyFunctionRegistry reg = PropertyFunctionRegistry.get(ARQ.getContext());
        if (reg == null) {
            reg = PropertyFunctionRegistry.standardRegistry();
            PropertyFunctionRegistry.set(ARQ.getContext(), reg);
        }
        return reg;
    }

    public void put(String uri, PropertyFunctionFactory factory) {
        this.registry.put(uri, factory);
    }

    public void put(String uri, Class<?> extClass) {
        if (!PropertyFunction.class.isAssignableFrom(extClass)) {
            Log.warn(this, "Class " + extClass.getName() + " is not an PropertyFunction");
            return;
        }
        this.registry.put(uri, new PropertyFunctionFactoryAuto(extClass));
    }

    public boolean manages(String uri) {
        if (this.registry.containsKey(uri)) {
            return true;
        }
        return MappedLoader.isPossibleDynamicURI(uri, PropertyFunction.class);
    }

    public PropertyFunctionFactory get(String uri) {
        PropertyFunctionFactory ext = this.registry.get(uri);
        if (ext != null) {
            return ext;
        }
        if (this.attemptedLoads.contains(uri)) {
            return null;
        }
        Class<?> extClass = MappedLoader.loadClass(uri, PropertyFunction.class);
        if (extClass == null) {
            return null;
        }
        this.put(uri, extClass);
        this.attemptedLoads.add(uri);
        return this.registry.get(uri);
    }

    public boolean isRegistered(String uri) {
        return this.registry.containsKey(uri);
    }

    public PropertyFunctionFactory remove(String uri) {
        return this.registry.remove(uri);
    }

    public Iterator<String> keys() {
        return this.registry.keySet().iterator();
    }

    private void loadStdDefs() {
        this.put(ListPFunction.member.getURI(), listMember.class);
        this.put(ListPFunction.index.getURI(), listIndex.class);
        this.put(ListPFunction.length.getURI(), listLength.class);
        this.put(ListPFunction.listMember.getURI(), listMember.class);
        this.put(ListPFunction.listIndex.getURI(), listIndex.class);
        this.put(ListPFunction.listLength.getURI(), listLength.class);
        this.put(RDFS.member.getURI(), container.class);
    }
}

