/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.update;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.modify.GraphStoreBasic;
import com.hp.hpl.jena.update.GraphStore;

public class GraphStoreFactory {
    public static GraphStore create() {
        return new GraphStoreBasic(DatasetGraphFactory.createMem());
    }

    public static GraphStore create(Model model) {
        return GraphStoreFactory.create(model.getGraph());
    }

    public static GraphStore create(Graph graph) {
        return new GraphStoreBasic(DatasetGraphFactory.create(graph));
    }

    public static GraphStore create(Dataset dataset) {
        return GraphStoreFactory.create(dataset.asDatasetGraph());
    }

    public static GraphStore create(DatasetGraph datasetGraph) {
        if (datasetGraph instanceof GraphStore) {
            return (GraphStore)datasetGraph;
        }
        return new GraphStoreBasic(datasetGraph);
    }
}

