/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web;

import java.io.FilterInputStream;
import java.io.InputStream;
import org.apache.jena.atlas.web.ContentType;

public class TypedInputStream
extends FilterInputStream {
    private ContentType mediaType;
    private String baseURI;

    public TypedInputStream(InputStream in) {
        this(in, (ContentType)null, null);
    }

    public TypedInputStream(InputStream in, String mediaType, String charset) {
        this(in, mediaType, charset, null);
    }

    public TypedInputStream(InputStream in, String mediaType, String charset, String baseURI) {
        this(in, ContentType.create(mediaType, charset), baseURI);
    }

    public TypedInputStream(InputStream in, ContentType ct) {
        this(in, ct, null);
    }

    public TypedInputStream(InputStream in, ContentType ct, String baseURI) {
        super(in);
        this.mediaType = ct;
        this.baseURI = baseURI;
    }

    @Deprecated
    public String getMimeType() {
        return this.getContentType();
    }

    public String getContentType() {
        return this.mediaType == null ? null : this.mediaType.getContentType();
    }

    public String getCharset() {
        return this.mediaType == null ? null : this.mediaType.getCharset();
    }

    public ContentType getMediaType() {
        return this.mediaType;
    }

    public String getBaseURI() {
        return this.baseURI;
    }
}

