% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2pptx.R
\name{plot2office}
\alias{plot2office}
\title{Save plot/ggplot to Microsoft Powerpoint format}
\usage{
plot2office(
  x = NULL,
  target = "Report",
  append = FALSE,
  title = "",
  type = "pptx",
  preprocessing = "",
  echo = FALSE,
  parallel = FALSE,
  left = 1,
  top = 1,
  width = NULL,
  height = NULL,
  aspectr = NULL
)
}
\arguments{
\item{x}{An object of class ggplot2 or a string vector encoding plot or ggplot}

\item{target}{name of output file}

\item{append}{logical value}

\item{title}{Optional character vector of plot title}

\item{type}{"pptx" or "docx"}

\item{preprocessing}{A string of R code or ""}

\item{echo}{logical. If true, show code.}

\item{parallel}{logical. If true, add two plots side by side}

\item{left}{left margin}

\item{top}{top margin}

\item{width}{desired width of the plot}

\item{height}{desired height of the plot}

\item{aspectr}{desired aspect ratio of the plot}
}
\description{
Save plot/ggplot to Microsoft Powerpoint format
}
\examples{
\donttest{
x=c("plot(iris)","ggplot(mtcars,aes(x=hp,y=mpg))+geom_point()")
plot2office(x,title="2 plots",parallel=TRUE)
plot2office(x,title="2 plots",parallel=TRUE,echo=TRUE,append=TRUE)
plot2office(x,parallel=TRUE,echo=TRUE,append=TRUE)
}
}
