% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelApply.R
\name{modelApply}
\alias{modelApply}
\title{modelApply}
\usage{
modelApply(model, img)
}
\arguments{
\item{model}{List object as provided by \emph{moveModel()}.}

\item{img}{Object of class \emph{RasterLayer}, \emph{RasterStack} or \emph{RasterBrick}.}
}
\value{
A \emph{Raster}.
}
\description{
Apply a model or an ensemble of models to raster data.
}
\details{
{The function uses the output of \emph{moveModel()}. If this contains a 
list of models from multiple runs, the function creates a stack of predictions 
and summarizes it on a pixel-by-pixel basis using a weighted mean. The weights 
are defined by the average performance for \emph{presence} and \emph{background} 
samples in each iteration.}
}
\examples{
\dontrun{
 
 require(rgdal)
 require(raster)
 require(sp)
 
 # read example data
 file <- system.file('extdata', 'konstanz_20130805-20130811.shp', package="rsMove")
 moveData <- shapefile(file)

 # extract samples
 ot = as.Date(moveData@data$date)
 samples <- sampleMove(xy=moveData, ot=ot, error=10, method='m')

 # read remote sensing data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'tc.*tif', full.names=TRUE)
 rsStk <- stack(file)
 
 # retrieve remote sensing data for samples
 rsQuery <- dataQuery(xy=samples,img=rsStk, rd=TRUE)
 
 # identify unique sample regions
 label <- labelSample(xy=rsQuery, rad=90, npx=1, pxr=rsStack)
 
 # select background samples
 ind <- which(label>0) # selected samples
 bSamples <- backSample(xy=moveData[ind,], rid=label[ind], img=rsStk, method='pca')
 
 # derive model predictions
 p.model <- moveModel(pxy=rsQuery, axy=bSamples, label=label)
 
 # derive prediction from model ensemble
 prob <- modelApply(p.model, rsStack)
 
 # see output
 plot(prob)
 
}
}
\seealso{
\code{\link{segRaster}} \code{\link{moveModel}}
}
