% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segRaster.R
\name{segRaster}
\alias{segRaster}
\title{segRaster}
\usage{
segRaster(x, break.point = 0.1, min.value = 0.5)
}
\arguments{
\item{x}{Object of class \emph{RasterLayer}.}

\item{break.point}{Difference threshold. Default is 0.05.}

\item{min.value}{Minimum value. Default is 0.5.}
}
\value{
A list object.
}
\description{
{Connected-region based raster segmentation that preserves spatial gradients.}
}
\details{
{The function segments \emph{x} using a connected component region labeling approach. For each pixel, the
function estimates the difference between it and its immediate neighbors. The pixels where the difference is below
\emph{break.point} are aggregated into a single region. Moreover, the user can define a minimum pixel value using
\emph{min.value} which will ignore all pixels below it. The output of this function consists of:
\itemize{
 \item{\emph{regions} - Region raster image.}
 \item{\emph{stats} - Basic statistics for each pixel region.}}}
}
\examples{
\dontrun{

 require(raster)

 # load example probability image
 file <- system.file('extdata', 'probabilities.tif', package="rsMove")
 r <- raster(file)

 # segment probabilities
 rs <- segRaster(r)

}
}
\seealso{
\code{\link{predictResources}}
}
