% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plausibilityTest.R
\name{plausibilityTest}
\alias{plausibilityTest}
\title{plausibilityTest}
\usage{
plausibilityTest(x, y, class.labels = NULL)
}
\arguments{
\item{x}{Object of class \emph{RasterLayer} and \emph{RasterStack}.}

\item{y}{Object of class \emph{RasterLayer}.}

\item{class.labels}{Labels of classes in \emph{y} provided as a character vector.}
}
\value{
A \emph{list}.
}
\description{
Quantifies and plots the distribution of pixels within a mask over a reference categorical raster object.
}
\details{
{For each lazer in \emph{x}, (e.g. classification mask) the function returns the absolute and relative count of non-NA
pixels within each unique value of \emph{y} (e.g. land cover map). Then, the results for each layer are compared in a combined
plot. The output of the function is a list consisting of:
 \itemize{
 \item{\emph{absolute.count} - Absolute pixel count for each layer of \emph{x} overlapping with each value of \emph{y}.}
 \item{\emph{relative.count} - Relative pixel count for each layer of \emph{x} overlapping with each value of \emph{y}.}
 \item{\emph{relative.plot} - Plot comparing the relative pixel count of the layers in \emph{x} within each value of \emph{y}.}}}
}
\examples{
{

 require(raster)

 # load example probability image
 file <- system.file('extdata', 'probabilities.tif', package="rsMove")
 p <- raster(file) > 0.5

 # land cover map
 lc <- raster(system.file('extdata', 'landCover.tif', package="rsMove"))

 # segment probabilities
 pt <- plausibilityTest(p, lc)

 # show plot
 pt$relative.plot

 # see relative sample count
 head(pt$relative.count)

}
}
