% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deployments.R
\name{deployments}
\alias{deployments}
\title{List Application Deployments}
\usage{
deployments(appPath, nameFilter = NULL, accountFilter = NULL,
  serverFilter = NULL, excludeOrphaned = TRUE)
}
\arguments{
\item{appPath}{The path to the content that was deployed, either a directory
or an individual document.}

\item{nameFilter}{Return only deployments matching the given name (optional)}

\item{accountFilter}{Return only deployments matching the given account
(optional)}

\item{serverFilter}{Return only deployments matching the given server
(optional)}

\item{excludeOrphaned}{If \code{TRUE} (the default), return only deployments
made by a currently registered account. Deployments made from accounts that
are no longer registered (via e.g.\code{\link{removeAccount}}) will not be
returned.}
}
\value{
Returns a data frame with at least following columns:
\tabular{ll}{
\code{name} \tab Name of deployed application\cr
\code{account} \tab Account owning deployed application\cr
\code{bundleId} \tab Identifier of deployed application's bundle\cr
\code{url} \tab URL of deployed application\cr
\code{when} \tab When the application was deployed (in seconds since the
  epoch)\cr
}

If additional metadata has been saved with the deployment record using the
\code{metadata} argument to \code{\link{deployApp}}, the frame will include
additional columns.
}
\description{
List deployment records for a given application.
}
\examples{
\dontrun{

# Return all deployments of the ~/r/myapp directory made with the 'abc'
# account
deployments("~/r/myapp", accountFilter="abc")
}
}
\seealso{
\code{\link{applications}} to get a list of deployments from the
  server, and \code{\link{deployApp}} to create a new deployment.
}

