% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsdNE.R
\name{sym}
\alias{sym}
\title{This generates a class of symmetric rotatable response surface designs with neighbour effects under a polynomial model of order (s1-1)}
\usage{
sym(s1, n1, c)
}
\arguments{
\item{s1}{Number of levels of n1 factors, 1<s1<=6}

\item{n1}{Number of factors, 1<n1<=4}

\item{c}{Value of alpha (Coefficient of neighbour effects), 0<=c<=1}
}
\value{
his function generates rotatable designs as well as Z_prime_Z matrix,
inv(Z_primeZ) matrix and variance estimated response for the (s1^n1) factorial combination.
}
\description{
This function generates symmetrical rotatable response surface designs in the presence of neighbour effects for n1 factors each at s1 levels.
}
\examples{
library(rsdNE)
sym(2,2,0.5)
##output:
## X matrix
#      [,1] [,2] [,3]
# [1,]    1   -1   -1
# [2,]    1    1    1
# [3,]    1    1   -1
# [4,]    1   -1    1
# [5,]    1   -1   -1
# [6,]    1    1    1
# [7,]    1   -1    1
# [8,]    1    1   -1
# [9,]    1   -1   -1
#[10,]    1    1    1
## Z prime Z matrix
#     [,1] [,2] [,3]
#[1,]   32    0    0
#[2,]    0    4    0
#[3,]    0    0    4
## Z prime Z inverse matrix
#     [,1]   [,2]   [,3]
#[1,] 0.03125 0.00 0.00
#[2,] 0.00000 0.25 0.00
#[3,] 0.00000 0.00 0.25
#[1] "total number of runs" "8"
#[1] "variance of esitmated response" "0.5312"
}
\references{
Sarika et al.2009, Communications in Statistics-Theory and Methods; Sarika et al.2013, Ars Combinatoria
}
\author{
Ashutosh Dalal, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Seema Jaggi, Education Division, ICAR, Krishi Anusandhan Bhawan - II, Pusa, New Delhi.
Eldho Varghese,Fishery Resources Assessment Division,ICAR-CMFRI, Kochi.
Subhasish Sarkar, Division of Computer Application,ICAR-IASRI, New Delhi.
Arpan Bhowmik, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Cini Varghese, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Anindita Datta, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Soumen Pal, Division of Computer Application,ICAR-IASRI, New Delhi.
}
