% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{distance_euclidean_pairwise}
\alias{distance_euclidean_pairwise}
\alias{distance_hausdorff_pairwise}
\alias{distance_vicenty_pairwise}
\alias{distance_geodesic_pairwise}
\alias{distance_haversine_pairwise}
\alias{distance_euclidean_matrix}
\alias{distance_hausdorff_matrix}
\alias{distance_vicenty_matrix}
\alias{distance_geodesic_matrix}
\alias{distance_haversine_matrix}
\title{Calculate Distances}
\usage{
distance_euclidean_pairwise(x, y)

distance_hausdorff_pairwise(x, y)

distance_vicenty_pairwise(x, y)

distance_geodesic_pairwise(x, y)

distance_haversine_pairwise(x, y)

distance_euclidean_matrix(x, y)

distance_hausdorff_matrix(x, y)

distance_vicenty_matrix(x, y)

distance_geodesic_matrix(x, y)

distance_haversine_matrix(x, y)
}
\arguments{
\item{x}{and object of class \code{rsgeo}}

\item{y}{and object of class \code{rsgeo}}
}
\value{
For \verb{_matrix} functions, returns a dense matrix of distances whereas \verb{_pairwise}
functions return a numeric vector.
}
\description{
Calculates distances between two vectors of geometries. There are
a number of different distance methods that can be utilized.
}
\details{
There are \verb{_pairwise()} and \verb{_matrix()} suffixed functions to
generate distances pairwise or as a dense matrix respectively.
The pairwise functions calculate distances between the ith element
of each vector. Whereas the matrix functions calculate the distance
between each and every geometry.

Euclidean distance should be used for planar geometries. Haversine,
Geodesic, and Vicenty are all methods of calculating distance
based on spherical geometries. There is no concept of spherical
geometries in rsgeo, so choose your distance measure appropriately.
\subsection{Notes}{
\itemize{
\item Hausdorff distance is calculated using Euclidean distance.
\item Haversine, Geodesic, and Vicenty distances only work with \code{rs_POINT} geometries.
}
}
}
\examples{
set.seed(1)
x <- geom_point(runif(5, -1, 1), runif(5, -1, 1))
y <- rev(x)

distance_euclidean_matrix(x, y)
distance_hausdorff_matrix(x, y)
distance_vicenty_matrix(x, y)
distance_geodesic_matrix(x, y)
distance_haversine_matrix(x, y)

distance_euclidean_pairwise(x, y)
distance_hausdorff_pairwise(x, y)
distance_vicenty_pairwise(x, y)
distance_geodesic_pairwise(x, y)
distance_haversine_pairwise(x, y)
}
