## ----setup, include = FALSE-------------------------------------------------------------------------------------------------------------------------
options(width = 150)
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = "center", fig.height = 6, fig.width = 6,
  out.width = "66.66%"
)

## ----ex1-load-data----------------------------------------------------------------------------------------------------------------------------------
library(rsimsum)
data("MIsim", package = "rsimsum")

## ----ex1-inspect-data-------------------------------------------------------------------------------------------------------------------------------
head(MIsim, n = 10)

## ----ex1-included-variables-------------------------------------------------------------------------------------------------------------------------
str(MIsim)

## ----ex1-simsum-------------------------------------------------------------------------------------------------------------------------------------
s1 <- simsum(data = MIsim, estvarname = "b", true = 0.50, se = "se", methodvar = "method", ref = "CC")

## ----ex1-summary-simsum-----------------------------------------------------------------------------------------------------------------------------
ss1 <- summary(s1)
ss1

## ----ex1-table--------------------------------------------------------------------------------------------------------------------------------------
library(knitr)
kable(get_data(ss1))

## ----ex1-plot-bias----------------------------------------------------------------------------------------------------------------------------------
library(ggplot2)
ggplot(get_data(ss1, sstat = "bias"), aes(x = method, y = coef, ymin = lower, ymax = upper)) +
  geom_hline(yintercept = 0, color = "red", lty = "dashed") +
  geom_point() +
  geom_errorbar(width = 1 / 3) +
  theme_bw() +
  labs(x = "Method", y = "Bias")

## ----ex1-plot-cov-----------------------------------------------------------------------------------------------------------------------------------
ggplot(get_data(ss1, sstat = "cover"), aes(x = method, y = coef, ymin = lower, ymax = upper)) +
  geom_hline(yintercept = 0.95, color = "red", lty = "dashed") +
  geom_point() +
  geom_errorbar(width = 1 / 3) +
  coord_cartesian(ylim = c(0, 1)) +
  theme_bw() +
  labs(x = "Method", y = "Coverage")

## ----ex1-dropbig-simsum-----------------------------------------------------------------------------------------------------------------------------
s1.2 <- simsum(data = MIsim, estvarname = "b", true = 0.50, se = "se", methodvar = "method", ref = "CC", dropbig = TRUE, max = 4, semax = 1.5)

## ----ex1-dropbig-dropbig----------------------------------------------------------------------------------------------------------------------------
dropbig(s1.2)

## ----ex1-dropbig-summary-simsum---------------------------------------------------------------------------------------------------------------------
summary(s1.2)

## ----ex2-load-data----------------------------------------------------------------------------------------------------------------------------------
data("relhaz", package = "rsimsum")

## ----ex2-inspect-data-------------------------------------------------------------------------------------------------------------------------------
head(relhaz, n = 10)

## ----ex2-included-variables-------------------------------------------------------------------------------------------------------------------------
str(relhaz)

## ----ex2-simsum-------------------------------------------------------------------------------------------------------------------------------------
s2 <- simsum(data = relhaz, estvarname = "theta", true = -0.50, se = "se", methodvar = "model", by = c("baseline", "n"))
s2

## ----ex2-summary-simsum-----------------------------------------------------------------------------------------------------------------------------
ss2 <- summary(s2)
ss2

## ----ex2-plot-bias----------------------------------------------------------------------------------------------------------------------------------
ggplot(get_data(ss2, sstat = "bias"), aes(x = model, y = coef, ymin = lower, ymax = upper)) +
  geom_hline(yintercept = 0, color = "red", lty = "dashed") +
  geom_point() +
  geom_errorbar(width = 1 / 3) +
  facet_grid(baseline ~ n) +
  theme_bw() +
  labs(x = "Method", y = "Bias")

