% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runread_biomee_f.R
\name{runread_biomee_f}
\alias{runread_biomee_f}
\title{Run BiomeE}
\usage{
runread_biomee_f(drivers, makecheck = TRUE, parallel = FALSE, ncores = 2)
}
\arguments{
\item{drivers}{A nested data frame with one row for each site and columns
named according to the arguments of function `runread_biomee_f_bysite()`.
See `?run_biomee_f_bysite` for the list of parameters and forcing data required.}

\item{makecheck}{Flag specifying whether checks are performed to verify forcings.}

\item{parallel}{Flag specifying whether simulations are to be
parallelised (sending data from a certain number of sites to each core). 
Defaults to \code{FALSE}.}

\item{ncores}{An integer specifying the number of cores used for parallel 
computing. Defaults to 2.}
}
\value{
A tibble with one row for each site and model outputs stored 
in the nested column \code{data}. See `?run_biomee_f_bysite` for a
description of the BiomeE output variables.
}
\description{
Runs BiomeE model for multiple sites.
}
\examples{
\donttest{
# Example BiomeE model run

runread_biomee_f(
  drivers = biomee_gs_leuning_drivers
)
runread_biomee_f(
  drivers = biomee_p_model_drivers
)
}
}
