% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{train_test_split}
\alias{train_test_split}
\title{Creates cross-validation set from user-item interactions}
\usage{
train_test_split(x, test_proportion = 0.5)
}
\arguments{
\item{x}{sparse user-item interation matrix. Internally \code{Matrix::TsparseMatrix} is used.}

\item{test_proportion}{- proportion of the observations for each user to keep as "test" data.}
}
\description{
Basic splitting of the user-item interaction matrix into train and testing part.
Useful for when data doesn't have time dimension.
Usually during model tuning it worth to keep some \code{x} matrix as hold-out data set.
Then this \code{x} could be splitted in 2 parts - \emph{train} and \emph{test}.
Model tries to predict \emph{test} data using \emph{train}
}
\keyword{internal}
