% Generated by roxygen2 (4.0.2): do not edit by hand
\name{as.list.rstack}
\alias{as.list.rstack}
\title{Convert an rstack to a list}
\usage{
\method{as.list}{rstack}(x, ...)
}
\arguments{
\item{x}{rstack to convert.}

\item{...}{additional arguments passed to as.list after initial conversion to list.}
}
\value{
a list containing the elements of the stack in top-to-bottom order.
}
\description{
Converts an rstack to a list, where the top of the stack becomes
the first element of the list, the second-from-top the second, and so on.
}
\details{
Runs in \eqn{O(N)} time in the size of the stack, but the generated list is pre-allocated for efficiency.
}
\examples{
s <- rstack()
s <- insert_top(s, "a")
s <- insert_top(s, "b")

slist <- as.list(s)
print(slist)
}
\seealso{
\code{\link{as.data.frame.rstack}}
}

