% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-and-summary.R
\name{summary.stanreg}
\alias{as.data.frame.summary.stanreg}
\alias{print.summary.stanreg}
\alias{summary.stanreg}
\title{Summary method for stanreg objects}
\usage{
\method{summary}{stanreg}(object, pars = NULL, regex_pars = NULL,
  probs = NULL, ..., digits = 1)

\method{print}{summary.stanreg}(x, digits = max(1, attr(x, "print.digits")),
  ...)

\method{as.data.frame}{summary.stanreg}(x, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{pars}{An optional character vector specifying a subset of parameters to
display. Parameters can be specified by name or several shortcuts can be 
used. Using \code{pars="beta"} will restrict the displayed parameters to 
only the regression coefficients (without the intercept). \code{"alpha"} 
can also be used as a shortcut for \code{"(Intercept)"}. If the model has 
varying intercepts and/or slopes they can be selected using \code{pars = 
"varying"}. If \code{pars} is \code{NULL} all parameters are selected. See 
Examples.}

\item{regex_pars}{An optional character vector of \link[=grep]{regular 
expressions} to use for parameter selection. \code{regex_pars} can be used
in place of \code{pars} or in addition to \code{pars}. Currently, all
functions that accept a \code{regex_pars} argument ignore it for models fit
using optimization.}

\item{probs}{For models fit using MCMC or one of the variational algorithms, 
an optional numeric vector of probabilities passed to 
\code{\link[stats]{quantile}}.}

\item{...}{Currently ignored.}

\item{digits}{Number of digits to use for formatting numbers when printing. 
When calling \code{summary}, the value of digits is stored as the 
\code{"print.digits"} attribute of the returned object.}

\item{x}{An object of class \code{"summary.stanreg"}.}
}
\value{
The \code{summary} method returns an object of class 
  \code{"summary.stanreg"}, which is a matrix of summary statistics and 
  diagnostics, with attributes storing information for use by the
  \code{print} method. The \code{print} method for \code{summary.stanreg}
  objects is called for its side effect and just returns its input. The 
  \code{as.data.frame} method for \code{summary.stanreg} objects converts the
  matrix to a data.frame, preserving row and column names but dropping the 
  \code{print}-related attributes.
}
\description{
Summaries of parameter estimates and MCMC convergence diagnostics 
(Monte Carlo error, effective sample size, Rhat).
}
\examples{
if (!exists("example_model")) example(example_model) 
summary(example_model, probs = c(0.1, 0.9))

# These produce the same output for this example, 
# but the second method can be used for any model
summary(example_model, pars = c("(Intercept)", "size", 
                                paste0("period", 2:4)))
summary(example_model, pars = c("alpha", "beta"))

# Only show parameters varying by group
summary(example_model, pars = "varying")
as.data.frame(summary(example_model, pars = "varying"))

}
\seealso{
\code{\link{print.stanreg}}, \code{\link{stanreg-methods}}
}

