% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factors.R
\name{convert_as_factor}
\alias{convert_as_factor}
\alias{set_ref_level}
\alias{reorder_levels}
\title{Factors}
\usage{
convert_as_factor(data, ..., vars = NULL, make.valid.levels = FALSE)

set_ref_level(data, name, ref)

reorder_levels(data, name, order)
}
\arguments{
\item{data}{a data frame}

\item{...}{one unquoted expressions (or variable name) specifying the name of
the variables you want to convert into factor. Alternative to the argument
\code{vars}.}

\item{vars}{a character vector specifying the variables to convert into
factor.}

\item{make.valid.levels}{logical. Default is FALSE. If TRUE, converts the
variable to factor and add a leading character (x) if starting with a digit.}

\item{name}{a factor variable name.}

\item{ref}{the reference level}

\item{order}{a character vector specifying the order of the factor levels}
}
\description{
Provides pipe-friendly functions to convert simultaneously
 multiple variables into a factor variable.

 Helper functions are also available to set the reference level and the
 levels order.
}
\section{Functions}{
\itemize{
\item \code{convert_as_factor}: Convert one or multiple variables into factor.

\item \code{set_ref_level}: Change a factor reference level or group.

\item \code{reorder_levels}: Change the order of a factor levels
}}

\examples{
# Create a demo data
df <- tibble(
  group = c("a", "a", "b", "b", "c", "c"),
  time = c("t1", "t2", "t1", "t2", "t1", "t2"),
  value = c(5, 6, 1, 3, 4, 5)
)
df
# Convert group and time into factor variable
result <- df \%>\% convert_as_factor(group, time)
result
# Show group levels
levels(result$group)

# Set c as the reference level (the first one)
result <- result \%>\%
  set_ref_level("group", ref = "c")
levels(result$group)

# Set the order of levels
result <- result \%>\%
  reorder_levels("group", order = c("b", "c", "a"))
levels(result$group)

}
