% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_normal_pars.R
\name{lnorm_mean}
\alias{lnorm_mean}
\alias{lnorm_sd}
\alias{find_pars_lnorm}
\title{Log-normal distribution parameters}
\usage{
lnorm_mean(meanlog, sdlog)

lnorm_sd(meanlog, sdlog)

find_pars_lnorm(m, sd)
}
\arguments{
\item{meanlog}{mean (expected value)of the distribution on the log scale}

\item{sdlog}{standard deviation of the distribution on the log scale}

\item{m}{mean (expected value) of the distribution on the exponential scale}

\item{sd}{standard deviation of the distribution on the exponential scale}
}
\value{
\code{lnorm_mean()} and \code{lnorm_sd()} return numeric vectors;
\code{find_pars_lnorm()} returns named numeric vector with elements named
\emph{meanlog} describing means and elements named \emph{sdlog} describing
standard deviations.
}
\description{
Functions return parameters of a log-normal distribution on the
exponentiated scale (\code{lnorm_mean}, \code{lnorm_sd}) or values of
parameters on the log scale that will result in given values of parameters
on the exponentiated scale (\code{find_pars_lnorm}).
}
\examples{
# actual expected value of the log-normal distribution with the log scale
# parameters of 3 and 1.5 respectively
lnorm_mean(3, 1.5)
# check:
mean(rlnorm(10^6, 3, 1.5))
# actual standard deviation of the log-normal distribution with the log scale
# parameters of 3 and 1.5 respectively
lnorm_sd(3, 1.5)
# check:
sd(rlnorm(10^6, 3, 1.5))
# what log scale parameters one should use to get actual (exponentiated scale)
# expected value and standard deviaton of the geneareted data of 1 and 0.2
# respectively?
(p <- find_pars_lnorm(1, 0.2))
# check:
lnorm_mean(p[1], p[2])
lnorm_sd(p[1], p[2])
}
