/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CompressedSerializedObject
implements Serializable {
    private static final long serialVersionUID = -2749094857545759562L;
    private final byte[] storedObjectArray;

    public CompressedSerializedObject(Object toStore) throws Exception {
        ByteArrayOutputStream ostream;
        ByteArrayOutputStream os = ostream = new ByteArrayOutputStream();
        ObjectOutputStream p = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(os)));
        p.writeObject(toStore);
        p.flush();
        p.close();
        this.storedObjectArray = ostream.toByteArray();
    }

    public final boolean equals(Object compareTo) {
        if (compareTo == null) {
            return false;
        }
        if (!compareTo.getClass().equals(this.getClass())) {
            return false;
        }
        byte[] compareArray = ((CompressedSerializedObject)compareTo).storedObjectArray;
        if (compareArray.length != this.storedObjectArray.length) {
            return false;
        }
        int i = 0;
        while (i < compareArray.length) {
            if (compareArray[i] != this.storedObjectArray[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object getObject() {
        try {
            ByteArrayInputStream istream = new ByteArrayInputStream(this.storedObjectArray);
            ObjectInputStream p = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(istream)));
            Object toReturn = p.readObject();
            istream.close();
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int hashCode() {
        return this.storedObjectArray.length;
    }
}

